/*
 * Decompiled with CFR 0.152.
 */
package com.zhoupu.printer;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import javax.print.PrintService;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.printing.PDFPageable;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;

public class Application {
    public static void main(String[] args) throws Exception {
        Application.run(args);
    }

    public static void run(String[] args) throws Exception {
        String printName;
        String pageStr;
        if (args.length < 1) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38");
        }
        String file = args[0];
        PDDocument document = PDDocument.load(new File(file));
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (args.length > 1 && !"0".equals(pageStr = args[1])) {
            String[] pageArr;
            for (String pages : pageArr = pageStr.split(",")) {
                if (pages.contains("-")) {
                    String[] range = pages.split("-");
                    for (int i = Integer.parseInt(range[0]); i <= Integer.parseInt(range[1]); ++i) {
                        list.add(i);
                    }
                    continue;
                }
                list.add(Integer.parseInt(pages));
            }
        }
        int i = 1;
        double pWidth = 0.0;
        double pHeight = 0.0;
        for (PDPage page : document.getPages()) {
            System.out.println("width:" + page.getMediaBox().getWidth() + "; height:" + page.getMediaBox().getHeight());
            pWidth = page.getMediaBox().getWidth();
            pHeight = page.getMediaBox().getHeight();
            if (list.size() > 0 && !list.contains(i)) {
                System.out.println("remove page " + i);
                document.removePage(page);
            }
            ++i;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        if (args.length > 2 && null != (printName = args[2]) && !"".equals(printName)) {
            PrintService[] printServices;
            for (PrintService printService : printServices = PrinterJob.lookupPrintServices()) {
                if (!printName.equals(printService.getName())) continue;
                job.setPrintService(printService);
                break;
            }
        }
        PageFormat format = job.defaultPage();
        job.setPageable(new PDFPageable(document));
        Paper paper = new Paper();
        if (args.length == 5) {
            double width = Double.parseDouble(args[3]);
            double height = Double.parseDouble(args[4]);
            width = width * 72.0 * 10.0 / 254.0;
            height = height * 72.0 * 10.0 / 254.0;
            paper.setSize(width, height);
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        } else {
            if (format.getWidth() > 0.0 && format.getHeight() > 0.0) {
                paper.setSize(format.getWidth(), format.getHeight());
            } else if (pWidth > 0.0 && pHeight > 0.0) {
                paper.setSize(pWidth, pHeight);
            }
            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        }
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(paper);
        Book book = new Book();
        PDFPrintable pdfPrintable = new PDFPrintable(document, Scaling.SCALE_TO_FIT);
        job.setPrintable(pdfPrintable);
        book.append(pdfPrintable, pageFormat, document.getNumberOfPages());
        job.setPageable(book);
        System.out.println("print starting");
        job.print();
    }
}

