/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import sun.misc.JavaNetAccess;
import sun.misc.SharedSecrets;
import sun.security.ssl.Alert;
import sun.security.ssl.BaseSSLSocketImpl;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.InputRecord;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketInputRecord;
import sun.security.ssl.SSLSocketOutputRecord;
import sun.security.ssl.SSLTransport;
import sun.security.ssl.TransportContext;
import sun.security.ssl.Utilities;

public final class SSLSocketImpl
extends BaseSSLSocketImpl
implements SSLTransport {
    final SSLContextImpl sslContext;
    final TransportContext conContext;
    private final AppInputStream appInput = new AppInputStream();
    private final AppOutputStream appOutput = new AppOutputStream();
    private String peerHost;
    private boolean autoClose;
    private boolean isConnected = false;
    private volatile boolean tlsIsClosed = false;
    private static final boolean trustNameService = Utilities.getBooleanProperty("jdk.tls.trustNameService", false);

    SSLSocketImpl(SSLContextImpl sSLContextImpl) {
        this.sslContext = sSLContextImpl;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sSLContextImpl, (SSLTransport)this, new SSLSocketInputRecord(handshakeHash), new SSLSocketOutputRecord(handshakeHash), true);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, SSLConfiguration sSLConfiguration) {
        this.sslContext = sSLContextImpl;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sSLContextImpl, (SSLTransport)this, sSLConfiguration, new SSLSocketInputRecord(handshakeHash), new SSLSocketOutputRecord(handshakeHash));
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n) throws IOException, UnknownHostException {
        this.sslContext = sSLContextImpl;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sSLContextImpl, (SSLTransport)this, new SSLSocketInputRecord(handshakeHash), new SSLSocketOutputRecord(handshakeHash), true);
        this.peerHost = string;
        InetSocketAddress inetSocketAddress = string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n) throws IOException {
        this.sslContext = sSLContextImpl;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sSLContextImpl, (SSLTransport)this, new SSLSocketInputRecord(handshakeHash), new SSLSocketOutputRecord(handshakeHash), true);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        this.sslContext = sSLContextImpl;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sSLContextImpl, (SSLTransport)this, new SSLSocketInputRecord(handshakeHash), new SSLSocketOutputRecord(handshakeHash), true);
        this.peerHost = string;
        this.bind(new InetSocketAddress(inetAddress, n2));
        InetSocketAddress inetSocketAddress = string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this.sslContext = sSLContextImpl;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sSLContextImpl, (SSLTransport)this, new SSLSocketInputRecord(handshakeHash), new SSLSocketOutputRecord(handshakeHash), true);
        this.bind(new InetSocketAddress(inetAddress2, n2));
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, Socket socket, InputStream inputStream, boolean bl) throws IOException {
        super(socket, inputStream);
        if (!socket.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        this.sslContext = sSLContextImpl;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sSLContextImpl, (SSLTransport)this, new SSLSocketInputRecord(handshakeHash), new SSLSocketOutputRecord(handshakeHash), false);
        this.autoClose = bl;
        this.doneConnect();
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, Socket socket, String string, int n, boolean bl) throws IOException {
        super(socket);
        if (!socket.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        this.sslContext = sSLContextImpl;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sSLContextImpl, (SSLTransport)this, new SSLSocketInputRecord(handshakeHash), new SSLSocketOutputRecord(handshakeHash), true);
        this.peerHost = string;
        this.autoClose = bl;
        this.doneConnect();
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (this.isLayered()) {
            throw new SocketException("Already connected");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new SocketException("Cannot handle non-Inet socket addresses.");
        }
        super.connect(socketAddress, n);
        this.doneConnect();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.sslContext.getSupportedCipherSuites());
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return CipherSuite.namesOf(this.conContext.sslConfig.enabledCipherSuites);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.conContext.sslConfig.enabledCipherSuites = CipherSuite.validValuesOf(stringArray);
    }

    @Override
    public String[] getSupportedProtocols() {
        return ProtocolVersion.toStringArray(this.sslContext.getSupportedProtocolVersions());
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return ProtocolVersion.toStringArray(this.conContext.sslConfig.enabledProtocols);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Protocols cannot be null");
        }
        this.conContext.sslConfig.enabledProtocols = ProtocolVersion.namesOf(stringArray);
    }

    @Override
    public SSLSession getSession() {
        try {
            this.ensureNegotiated(false);
        }
        catch (IOException iOException) {
            if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                SSLLogger.severe("handshake failed", iOException);
            }
            return new SSLSessionImpl();
        }
        return this.conContext.conSession;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.conContext.handshakeContext == null ? null : this.conContext.handshakeContext.handshakeSession;
    }

    @Override
    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.conContext.sslConfig.addHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.conContext.sslConfig.removeHandshakeCompletedListener(handshakeCompletedListener);
    }

    @Override
    public void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHandshake(boolean bl) throws IOException {
        if (!this.isConnected) {
            throw new SocketException("Socket is not connected");
        }
        if (this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed()) {
            throw new SocketException("Socket has been closed or broken");
        }
        TransportContext transportContext = this.conContext;
        synchronized (transportContext) {
            if (this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed()) {
                throw new SocketException("Socket has been closed or broken");
            }
            try {
                this.conContext.kickstart();
                if (!this.conContext.isNegotiated) {
                    this.readHandshakeRecord();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (bl) {
                    this.handleException(interruptedIOException);
                }
                throw this.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Couldn't kickstart handshaking", interruptedIOException);
            }
            catch (IOException iOException) {
                throw this.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Couldn't kickstart handshaking", iOException);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
    }

    @Override
    public synchronized void setUseClientMode(boolean bl) {
        this.conContext.setUseClientMode(bl);
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.conContext.sslConfig.isClientMode;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean bl) {
        this.conContext.sslConfig.clientAuthType = bl ? ClientAuthType.CLIENT_AUTH_REQUIRED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.conContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED;
    }

    @Override
    public synchronized void setWantClientAuth(boolean bl) {
        this.conContext.sslConfig.clientAuthType = bl ? ClientAuthType.CLIENT_AUTH_REQUESTED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.conContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUESTED;
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean bl) {
        this.conContext.sslConfig.enableSessionCreation = bl;
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.conContext.sslConfig.enableSessionCreation;
    }

    @Override
    public boolean isClosed() {
        return this.tlsIsClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.fine("duplex close of SSLSocket", new Object[0]);
        }
        if (this.isConnected()) {
            if (!this.isOutputShutdown()) {
                this.duplexCloseOutput();
            }
            if (!this.isInputShutdown()) {
                this.duplexCloseInput();
            }
        }
        if (this.isClosed()) return;
        try {
            this.closeSocket(false);
            return;
        }
        catch (IOException iOException) {
            if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) return;
            SSLLogger.warning("SSLSocket close failed", iOException);
            return;
        }
        finally {
            this.tlsIsClosed = true;
        }
        catch (IOException iOException) {
            try {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("SSLSocket duplex close failed", iOException);
                }
                if (this.isClosed()) return;
            }
            catch (Throwable throwable) {
                if (this.isClosed()) throw throwable;
                try {
                    this.closeSocket(false);
                    throw throwable;
                }
                catch (IOException iOException2) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) throw throwable;
                    SSLLogger.warning("SSLSocket close failed", iOException2);
                    throw throwable;
                }
                finally {
                    this.tlsIsClosed = true;
                }
            }
            try {
                this.closeSocket(false);
                return;
            }
            catch (IOException iOException3) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) return;
                SSLLogger.warning("SSLSocket close failed", iOException3);
                return;
            }
            finally {
                this.tlsIsClosed = true;
            }
        }
    }

    private void duplexCloseOutput() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.conContext.isNegotiated) {
            if (!this.conContext.protocolVersion.useTLS13PlusSpec()) {
                bl2 = true;
            } else {
                bl = true;
            }
        } else if (this.conContext.handshakeContext != null) {
            bl = true;
            ProtocolVersion protocolVersion = this.conContext.handshakeContext.negotiatedProtocol;
            if (protocolVersion == null || !protocolVersion.useTLS13PlusSpec()) {
                bl2 = true;
            }
        }
        this.closeNotify(bl);
        if (!this.isInputShutdown()) {
            this.bruteForceCloseInput(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeNotify(boolean bl) throws IOException {
        int n = this.getSoLinger();
        if (n >= 0) {
            boolean bl2;
            block16: {
                bl2 = Thread.interrupted();
                try {
                    if (this.conContext.outputRecord.recordLock.tryLock() || this.conContext.outputRecord.recordLock.tryLock(n, TimeUnit.SECONDS)) {
                        try {
                            this.deliverClosedNotify(bl);
                            break block16;
                        }
                        finally {
                            this.conContext.outputRecord.recordLock.unlock();
                        }
                    }
                    if (!super.isOutputShutdown()) {
                        if (this.isLayered() && !this.autoClose) {
                            throw new SSLException("SO_LINGER timeout, close_notify message cannot be sent.");
                        }
                        super.shutdownOutput();
                        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                            SSLLogger.warning("SSLSocket output duplex close failed: SO_LINGER timeout, close_notify message cannot be sent.", new Object[0]);
                        }
                    }
                    this.conContext.conSession.invalidate();
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                        SSLLogger.warning("Invalidate the session: SO_LINGER timeout, close_notify message cannot be sent.", new Object[0]);
                    }
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.conContext.outputRecord.recordLock.lock();
            try {
                this.deliverClosedNotify(bl);
            }
            finally {
                this.conContext.outputRecord.recordLock.unlock();
            }
        }
    }

    private void deliverClosedNotify(boolean bl) throws IOException {
        try {
            if (bl) {
                this.conContext.warning(Alert.USER_CANCELED);
            }
            this.conContext.warning(Alert.CLOSE_NOTIFY);
        }
        finally {
            if (!this.conContext.isOutboundClosed()) {
                this.conContext.outputRecord.close();
            }
            if (!(super.isOutputShutdown() || !this.autoClose && this.isLayered())) {
                super.shutdownOutput();
            }
        }
    }

    private void duplexCloseInput() throws IOException {
        boolean bl = false;
        if (this.conContext.isNegotiated && !this.conContext.protocolVersion.useTLS13PlusSpec()) {
            bl = true;
        }
        this.bruteForceCloseInput(bl);
    }

    private void bruteForceCloseInput(boolean bl) throws IOException {
        if (bl) {
            try {
                this.shutdown();
            }
            finally {
                if (!this.isInputShutdown()) {
                    this.shutdownInput(false);
                }
            }
        }
        if (!this.conContext.isInboundClosed()) {
            try (InputRecord inputRecord = this.conContext.inputRecord;){
                this.appInput.deplete();
            }
        }
        if (!(!this.autoClose && this.isLayered() || super.isInputShutdown())) {
            super.shutdownInput();
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        this.shutdownInput(true);
    }

    private void shutdownInput(boolean bl) throws IOException {
        if (this.isInputShutdown()) {
            return;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.fine("close inbound of SSLSocket", new Object[0]);
        }
        try {
            if (bl && !this.conContext.isInputCloseNotified && (this.conContext.isNegotiated || this.conContext.handshakeContext != null)) {
                throw new UnsupportedOperationException("method is not supported because of the TLS half-close policy");
            }
        }
        finally {
            this.conContext.closeInbound();
            if (!(!this.autoClose && this.isLayered() || super.isInputShutdown())) {
                super.shutdownInput();
            }
        }
    }

    @Override
    public boolean isInputShutdown() {
        return this.conContext.isInboundClosed() && (!this.autoClose && this.isLayered() || super.isInputShutdown());
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (this.isOutputShutdown()) {
            return;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.fine("close outbound of SSLSocket", new Object[0]);
        }
        this.conContext.closeOutbound();
        if (!(!this.autoClose && this.isLayered() || super.isOutputShutdown())) {
            super.shutdownOutput();
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this.conContext.isOutboundClosed() && (!this.autoClose && this.isLayered() || super.isOutputShutdown());
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected) {
            throw new SocketException("Socket is not connected");
        }
        if (this.conContext.isInboundClosed() || this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        return this.appInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNegotiated(boolean bl) throws IOException {
        if (this.conContext.isNegotiated || this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed()) {
            return;
        }
        TransportContext transportContext = this.conContext;
        synchronized (transportContext) {
            if (this.conContext.isNegotiated || this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed()) {
                return;
            }
            this.startHandshake(bl);
        }
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected) {
            throw new SocketException("Socket is not connected");
        }
        if (this.conContext.isOutboundDone() || this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        return this.appOutput;
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return this.conContext.sslConfig.getSSLParameters();
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        this.conContext.sslConfig.setSSLParameters(sSLParameters);
        if (this.conContext.sslConfig.maximumPacketSize != 0) {
            this.conContext.outputRecord.changePacketSize(this.conContext.sslConfig.maximumPacketSize);
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return this.conContext.applicationProtocol;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        if (this.conContext.handshakeContext != null) {
            return this.conContext.handshakeContext.applicationProtocol;
        }
        return null;
    }

    @Override
    public synchronized void setHandshakeApplicationProtocolSelector(BiFunction<SSLSocket, List<String>, String> biFunction) {
        this.conContext.sslConfig.socketAPSelector = biFunction;
    }

    @Override
    public synchronized BiFunction<SSLSocket, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return this.conContext.sslConfig.socketAPSelector;
    }

    private int readHandshakeRecord() throws IOException {
        while (!this.conContext.isInboundClosed()) {
            try {
                Plaintext plaintext = this.decode(null);
                if (plaintext.contentType != ContentType.HANDSHAKE.id || !this.conContext.isNegotiated) continue;
                return 0;
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                throw new SSLException("readHandshakeRecord", iOException);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer readApplicationRecord(ByteBuffer byteBuffer) throws IOException {
        while (!this.conContext.isInboundClosed()) {
            byteBuffer.clear();
            int n = this.conContext.inputRecord.bytesInCompletePacket();
            if (n < 0) {
                this.handleEOF(null);
                return null;
            }
            if (n > 33093) {
                throw new SSLProtocolException("Illegal packet size: " + n);
            }
            if (n > byteBuffer.remaining()) {
                byteBuffer = ByteBuffer.allocate(n);
            }
            try {
                Plaintext plaintext;
                SSLSocketImpl sSLSocketImpl = this;
                synchronized (sSLSocketImpl) {
                    plaintext = this.decode(byteBuffer);
                }
                if (plaintext.contentType != ContentType.APPLICATION_DATA.id || byteBuffer.position() <= 0) continue;
                return byteBuffer;
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                if (!(iOException instanceof SSLException)) {
                    throw new SSLException("readApplicationRecord", iOException);
                }
                throw iOException;
            }
        }
        return null;
    }

    private Plaintext decode(ByteBuffer byteBuffer) throws IOException {
        Plaintext plaintext;
        try {
            plaintext = byteBuffer == null ? SSLTransport.decode(this.conContext, null, 0, 0, null, 0, 0) : SSLTransport.decode(this.conContext, null, 0, 0, new ByteBuffer[]{byteBuffer}, 0, 1);
        }
        catch (EOFException eOFException) {
            plaintext = this.handleEOF(eOFException);
        }
        if (plaintext != Plaintext.PLAINTEXT_NULL && (this.conContext.inputRecord.seqNumIsHuge() || this.conContext.inputRecord.readCipher.atKeyLimit())) {
            this.tryKeyUpdate();
        }
        return plaintext;
    }

    private void tryKeyUpdate() throws IOException {
        if (!(this.conContext.handshakeContext != null || this.conContext.isOutboundClosed() || this.conContext.isInboundClosed() || this.conContext.isBroken)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("trigger key update", new Object[0]);
            }
            this.startHandshake();
        }
    }

    synchronized void doneConnect() throws IOException {
        if (this.peerHost == null || this.peerHost.isEmpty()) {
            boolean bl = trustNameService && this.conContext.sslConfig.isClientMode;
            this.useImplicitHost(bl);
        } else {
            this.conContext.sslConfig.serverNames = Utilities.addToSNIServerNameList(this.conContext.sslConfig.serverNames, this.peerHost);
        }
        InputStream inputStream = super.getInputStream();
        this.conContext.inputRecord.setReceiverStream(inputStream);
        OutputStream outputStream = super.getOutputStream();
        this.conContext.inputRecord.setDeliverStream(outputStream);
        this.conContext.outputRecord.setDeliverStream(outputStream);
        this.isConnected = true;
    }

    synchronized String getHost() {
        if (this.peerHost == null || this.peerHost.length() == 0) {
            this.useImplicitHost(true);
        }
        return this.peerHost;
    }

    private void useImplicitHost(boolean bl) {
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress == null) {
            return;
        }
        JavaNetAccess javaNetAccess = SharedSecrets.getJavaNetAccess();
        String string = javaNetAccess.getOriginalHostName(inetAddress);
        if (string != null && !string.isEmpty()) {
            this.peerHost = string;
            if (this.conContext.sslConfig.serverNames.isEmpty() && !this.conContext.sslConfig.noSniExtension) {
                this.conContext.sslConfig.serverNames = Utilities.addToSNIServerNameList(this.conContext.sslConfig.serverNames, this.peerHost);
            }
            return;
        }
        this.peerHost = !bl ? inetAddress.getHostAddress() : this.getInetAddress().getHostName();
    }

    public synchronized void setHost(String string) {
        this.peerHost = string;
        this.conContext.sslConfig.serverNames = Utilities.addToSNIServerNameList(this.conContext.sslConfig.serverNames, string);
    }

    private void handleException(Exception exception) throws IOException {
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.warning("handling exception", exception);
        }
        if (exception instanceof InterruptedIOException) {
            throw (IOException)exception;
        }
        boolean bl = exception instanceof SSLException;
        Alert alert = bl ? (exception instanceof SSLHandshakeException ? Alert.HANDSHAKE_FAILURE : Alert.UNEXPECTED_MESSAGE) : (exception instanceof IOException ? Alert.UNEXPECTED_MESSAGE : Alert.INTERNAL_ERROR);
        throw this.conContext.fatal(alert, exception);
    }

    private Plaintext handleEOF(EOFException eOFException) throws IOException {
        if (requireCloseNotify || this.conContext.handshakeContext != null) {
            SSLException sSLException = this.conContext.handshakeContext != null ? new SSLHandshakeException("Remote host terminated the handshake") : new SSLProtocolException("Remote host terminated the connection");
            if (eOFException != null) {
                sSLException.initCause(eOFException);
            }
            throw sSLException;
        }
        this.conContext.isInputCloseNotified = true;
        this.shutdownInput();
        return Plaintext.PLAINTEXT_NULL;
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.getPort();
    }

    @Override
    public boolean useDelegatedTask() {
        return false;
    }

    @Override
    public void shutdown() throws IOException {
        if (!this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("close the underlying socket", new Object[0]);
            }
            try {
                if (this.conContext.isInputCloseNotified) {
                    this.closeSocket(false);
                } else {
                    this.closeSocket(true);
                }
            }
            finally {
                this.tlsIsClosed = true;
            }
        }
    }

    private void closeSocket(boolean bl) throws IOException {
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.fine("close the SSL connection " + (bl ? "(initiative)" : "(passive)"), new Object[0]);
        }
        if (this.autoClose || !this.isLayered()) {
            super.close();
        } else if (bl && !this.conContext.isInboundClosed() && !this.isInputShutdown()) {
            this.waitForClose();
        }
    }

    private void waitForClose() throws IOException {
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.fine("wait for close_notify or alert", new Object[0]);
        }
        while (!this.conContext.isInboundClosed()) {
            try {
                Plaintext plaintext = this.decode(null);
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) continue;
                SSLLogger.finest("discard plaintext while waiting for close", plaintext);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
    }

    private class AppInputStream
    extends InputStream {
        private final byte[] oneByte = new byte[1];
        private ByteBuffer buffer = ByteBuffer.allocate(4096);
        private volatile boolean appDataIsAvailable = false;

        AppInputStream() {
        }

        @Override
        public int available() throws IOException {
            if (!this.appDataIsAvailable || this.checkEOF()) {
                return 0;
            }
            return this.buffer.remaining();
        }

        @Override
        public int read() throws IOException {
            int n = this.read(this.oneByte, 0, 1);
            if (n <= 0) {
                return -1;
            }
            return this.oneByte[0] & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException("the target buffer is null");
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException("buffer length: " + byArray.length + ", offset; " + n + ", bytes to read:" + n2);
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.checkEOF()) {
                return -1;
            }
            if (!(SSLSocketImpl.this.conContext.isNegotiated || SSLSocketImpl.this.conContext.isBroken || SSLSocketImpl.this.conContext.isInboundClosed() || SSLSocketImpl.this.conContext.isOutboundClosed())) {
                SSLSocketImpl.this.ensureNegotiated(true);
            }
            if (!SSLSocketImpl.this.conContext.isNegotiated || SSLSocketImpl.this.conContext.isBroken || SSLSocketImpl.this.conContext.isInboundClosed()) {
                throw new SocketException("Connection or inbound has closed");
            }
            AppInputStream appInputStream = this;
            synchronized (appInputStream) {
                int n3 = this.available();
                if (n3 > 0) {
                    int n4 = Math.min(n3, n2);
                    this.buffer.get(byArray, n, n4);
                    return n4;
                }
                this.appDataIsAvailable = false;
                try {
                    ByteBuffer byteBuffer = SSLSocketImpl.this.readApplicationRecord(this.buffer);
                    if (byteBuffer == null) {
                        return -1;
                    }
                    this.buffer = byteBuffer;
                    byteBuffer.flip();
                    int n5 = Math.min(n2, byteBuffer.remaining());
                    this.buffer.get(byArray, n, n5);
                    this.appDataIsAvailable = true;
                    return n5;
                }
                catch (Exception exception) {
                    SSLSocketImpl.this.handleException(exception);
                    return -1;
                }
            }
        }

        @Override
        public synchronized long skip(long l) throws IOException {
            int n;
            int n2;
            byte[] byArray = new byte[256];
            long l2 = 0L;
            while (l > 0L && (n2 = this.read(byArray, 0, n = (int)Math.min(l, (long)byArray.length))) > 0) {
                l -= (long)n2;
                l2 += (long)n2;
            }
            return l2;
        }

        @Override
        public void close() throws IOException {
            block3: {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest("Closing input stream", new Object[0]);
                }
                try {
                    SSLSocketImpl.this.close();
                }
                catch (IOException iOException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) break block3;
                    SSLLogger.warning("input stream close failed", iOException);
                }
            }
        }

        private boolean checkEOF() throws IOException {
            if (SSLSocketImpl.this.conContext.isBroken) {
                if (SSLSocketImpl.this.conContext.closeReason == null) {
                    return true;
                }
                throw new SSLException("Connection has closed: " + SSLSocketImpl.this.conContext.closeReason, SSLSocketImpl.this.conContext.closeReason);
            }
            if (SSLSocketImpl.this.conContext.isInboundClosed()) {
                return true;
            }
            if (SSLSocketImpl.this.conContext.isInputCloseNotified) {
                if (SSLSocketImpl.this.conContext.closeReason == null) {
                    return true;
                }
                throw new SSLException("Connection has closed: " + SSLSocketImpl.this.conContext.closeReason, SSLSocketImpl.this.conContext.closeReason);
            }
            return false;
        }

        private synchronized void deplete() {
            block4: {
                if (!SSLSocketImpl.this.conContext.isInboundClosed()) {
                    if (!(SSLSocketImpl.this.conContext.inputRecord instanceof SSLSocketInputRecord)) {
                        return;
                    }
                    SSLSocketInputRecord sSLSocketInputRecord = (SSLSocketInputRecord)SSLSocketImpl.this.conContext.inputRecord;
                    try {
                        sSLSocketInputRecord.deplete(SSLSocketImpl.this.conContext.isNegotiated && SSLSocketImpl.this.getSoTimeout() > 0);
                    }
                    catch (IOException iOException) {
                        if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) break block4;
                        SSLLogger.warning("input stream close depletion failed", iOException);
                    }
                }
            }
        }
    }

    private class AppOutputStream
    extends OutputStream {
        private final byte[] oneByte = new byte[1];

        private AppOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            this.oneByte[0] = (byte)n;
            this.write(this.oneByte, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException("the source buffer is null");
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException("buffer length: " + byArray.length + ", offset; " + n + ", bytes to read:" + n2);
            }
            if (n2 == 0) {
                return;
            }
            if (!(SSLSocketImpl.this.conContext.isNegotiated || SSLSocketImpl.this.conContext.isBroken || SSLSocketImpl.this.conContext.isInboundClosed() || SSLSocketImpl.this.conContext.isOutboundClosed())) {
                SSLSocketImpl.this.ensureNegotiated(true);
            }
            if (!SSLSocketImpl.this.conContext.isNegotiated || SSLSocketImpl.this.conContext.isBroken || SSLSocketImpl.this.conContext.isOutboundClosed()) {
                throw new SocketException("Connection or outbound has closed");
            }
            try {
                SSLSocketImpl.this.conContext.outputRecord.deliver(byArray, n, n2);
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                throw SSLSocketImpl.this.conContext.fatal(Alert.HANDSHAKE_FAILURE, sSLHandshakeException);
            }
            catch (SSLException sSLException) {
                throw SSLSocketImpl.this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, sSLException);
            }
            if (SSLSocketImpl.this.conContext.outputRecord.seqNumIsHuge() || SSLSocketImpl.this.conContext.outputRecord.writeCipher.atKeyLimit()) {
                SSLSocketImpl.this.tryKeyUpdate();
            }
        }

        @Override
        public void close() throws IOException {
            block3: {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest("Closing output stream", new Object[0]);
                }
                try {
                    SSLSocketImpl.this.close();
                }
                catch (IOException iOException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) break block3;
                    SSLLogger.warning("output stream close failed", iOException);
                }
            }
        }
    }
}

