/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.util.Map;
import sun.management.snmp.jvminstr.JvmRTClassPathEntryImpl;
import sun.management.snmp.jvminstr.JvmRuntimeImpl;
import sun.management.snmp.jvmmib.JvmRTClassPathTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmRTClassPathTableMetaImpl
extends JvmRTClassPathTableMeta {
    static final long serialVersionUID = -6914494148818455166L;
    private SnmpTableCache cache = new JvmRTClassPathTableCache(this, -1L);
    static final MibLogger log = new MibLogger(JvmRTClassPathTableMetaImpl.class);

    public JvmRTClassPathTableMetaImpl(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        super(snmpMib, snmpStandardObjectServer);
    }

    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        return this.getNextOid(null, object);
    }

    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        SnmpTableHandler snmpTableHandler;
        boolean bl = log.isDebugOn();
        if (bl) {
            log.debug("getNextOid", "previous=" + snmpOid);
        }
        if ((snmpTableHandler = this.getHandler(object)) == null) {
            if (bl) {
                log.debug("getNextOid", "handler is null!");
            }
            throw new SnmpStatusException(224);
        }
        SnmpOid snmpOid2 = snmpTableHandler.getNext(snmpOid);
        if (bl) {
            log.debug("*** **** **** **** getNextOid", "next=" + snmpOid2);
        }
        if (snmpOid2 == null) {
            throw new SnmpStatusException(224);
        }
        return snmpOid2;
    }

    protected boolean contains(SnmpOid snmpOid, Object object) {
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            return false;
        }
        return snmpTableHandler.contains(snmpOid);
    }

    public Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        Object object;
        String string;
        boolean bl = log.isDebugOn();
        if (bl) {
            log.debug("getEntry", "oid [" + snmpOid + "]");
        }
        if (snmpOid == null || snmpOid.getLength() != 1) {
            if (bl) {
                log.debug("getEntry", "Invalid oid [" + snmpOid + "]");
            }
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> map = JvmContextFactory.getUserData();
        String string2 = string = map == null ? null : "JvmRTClassPathTable.entry." + snmpOid.toString();
        if (map != null) {
            object = map.get(string);
            if (object != null) {
                if (bl) {
                    log.debug("getEntry", "Entry is already in the cache");
                }
                return object;
            }
            if (bl) {
                log.debug("getEntry", "Entry is not in the cache");
            }
        }
        if ((object = this.getHandler(map)) == null) {
            throw new SnmpStatusException(224);
        }
        Object object2 = object.getData(snmpOid);
        if (object2 == null) {
            throw new SnmpStatusException(224);
        }
        if (bl) {
            log.debug("getEntry", "data is a: " + object2.getClass().getName());
        }
        JvmRTClassPathEntryImpl jvmRTClassPathEntryImpl = new JvmRTClassPathEntryImpl((String)object2, (int)snmpOid.getOidArc(0));
        if (map != null && jvmRTClassPathEntryImpl != null) {
            map.put(string, jvmRTClassPathEntryImpl);
        }
        return jvmRTClassPathEntryImpl;
    }

    protected SnmpTableHandler getHandler(Object object) {
        SnmpTableHandler snmpTableHandler;
        Map map = object instanceof Map ? (Map)Util.cast(object) : null;
        if (map != null && (snmpTableHandler = (SnmpTableHandler)map.get("JvmRTClassPathTable.handler")) != null) {
            return snmpTableHandler;
        }
        snmpTableHandler = this.cache.getTableHandler();
        if (map != null && snmpTableHandler != null) {
            map.put("JvmRTClassPathTable.handler", snmpTableHandler);
        }
        return snmpTableHandler;
    }

    private static class JvmRTClassPathTableCache
    extends SnmpTableCache {
        static final long serialVersionUID = 3805032372592117315L;
        private JvmRTClassPathTableMetaImpl meta;

        JvmRTClassPathTableCache(JvmRTClassPathTableMetaImpl jvmRTClassPathTableMetaImpl, long l) {
            this.meta = jvmRTClassPathTableMetaImpl;
            this.validity = l;
        }

        @Override
        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> map = JvmContextFactory.getUserData();
            return this.getTableDatas(map);
        }

        @Override
        protected SnmpCachedData updateCachedDatas(Object object) {
            Object[] objectArray = JvmRuntimeImpl.getClassPath(object);
            long l = System.currentTimeMillis();
            int n = objectArray.length;
            SnmpOid[] snmpOidArray = new SnmpOid[n];
            for (int i = 0; i < n; ++i) {
                snmpOidArray[i] = new SnmpOid((long)(i + 1));
            }
            return new SnmpCachedData(l, snmpOidArray, objectArray);
        }
    }
}

