/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.util.Map;
import sun.management.snmp.jvminstr.JvmRTInputArgsEntryImpl;
import sun.management.snmp.jvminstr.JvmRuntimeImpl;
import sun.management.snmp.jvmmib.JvmRTInputArgsTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmRTInputArgsTableMetaImpl
extends JvmRTInputArgsTableMeta {
    static final long serialVersionUID = -2083438094888099238L;
    private SnmpTableCache cache = new JvmRTInputArgsTableCache(this, -1L);
    static final MibLogger log = new MibLogger(JvmRTInputArgsTableMetaImpl.class);

    public JvmRTInputArgsTableMetaImpl(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        super(snmpMib, snmpStandardObjectServer);
    }

    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        return this.getNextOid(null, object);
    }

    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        SnmpTableHandler snmpTableHandler;
        boolean bl = log.isDebugOn();
        if (bl) {
            log.debug("getNextOid", "previous=" + snmpOid);
        }
        if ((snmpTableHandler = this.getHandler(object)) == null) {
            if (bl) {
                log.debug("getNextOid", "handler is null!");
            }
            throw new SnmpStatusException(224);
        }
        SnmpOid snmpOid2 = snmpTableHandler.getNext(snmpOid);
        if (bl) {
            log.debug("*** **** **** **** getNextOid", "next=" + snmpOid2);
        }
        if (snmpOid2 == null) {
            throw new SnmpStatusException(224);
        }
        return snmpOid2;
    }

    protected boolean contains(SnmpOid snmpOid, Object object) {
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            return false;
        }
        return snmpTableHandler.contains(snmpOid);
    }

    public Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        Object object;
        String string;
        boolean bl = log.isDebugOn();
        if (bl) {
            log.debug("getEntry", "oid [" + snmpOid + "]");
        }
        if (snmpOid == null || snmpOid.getLength() != 1) {
            if (bl) {
                log.debug("getEntry", "Invalid oid [" + snmpOid + "]");
            }
            throw new SnmpStatusException(224);
        }
        Map<Object, Object> map = JvmContextFactory.getUserData();
        String string2 = string = map == null ? null : "JvmRTInputArgsTable.entry." + snmpOid.toString();
        if (map != null) {
            object = map.get(string);
            if (object != null) {
                if (bl) {
                    log.debug("getEntry", "Entry is already in the cache");
                }
                return object;
            }
            if (bl) {
                log.debug("getEntry", "Entry is not in the cache");
            }
        }
        if ((object = this.getHandler(map)) == null) {
            throw new SnmpStatusException(224);
        }
        Object object2 = object.getData(snmpOid);
        if (object2 == null) {
            throw new SnmpStatusException(224);
        }
        if (bl) {
            log.debug("getEntry", "data is a: " + object2.getClass().getName());
        }
        JvmRTInputArgsEntryImpl jvmRTInputArgsEntryImpl = new JvmRTInputArgsEntryImpl((String)object2, (int)snmpOid.getOidArc(0));
        if (map != null && jvmRTInputArgsEntryImpl != null) {
            map.put(string, jvmRTInputArgsEntryImpl);
        }
        return jvmRTInputArgsEntryImpl;
    }

    protected SnmpTableHandler getHandler(Object object) {
        SnmpTableHandler snmpTableHandler;
        Map map = object instanceof Map ? (Map)Util.cast(object) : null;
        if (map != null && (snmpTableHandler = (SnmpTableHandler)map.get("JvmRTInputArgsTable.handler")) != null) {
            return snmpTableHandler;
        }
        snmpTableHandler = this.cache.getTableHandler();
        if (map != null && snmpTableHandler != null) {
            map.put("JvmRTInputArgsTable.handler", snmpTableHandler);
        }
        return snmpTableHandler;
    }

    private static class JvmRTInputArgsTableCache
    extends SnmpTableCache {
        static final long serialVersionUID = 1693751105464785192L;
        private JvmRTInputArgsTableMetaImpl meta;

        JvmRTInputArgsTableCache(JvmRTInputArgsTableMetaImpl jvmRTInputArgsTableMetaImpl, long l) {
            this.meta = jvmRTInputArgsTableMetaImpl;
            this.validity = l;
        }

        @Override
        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> map = JvmContextFactory.getUserData();
            return this.getTableDatas(map);
        }

        @Override
        protected SnmpCachedData updateCachedDatas(Object object) {
            Object[] objectArray = JvmRuntimeImpl.getInputArguments(object);
            long l = System.currentTimeMillis();
            SnmpOid[] snmpOidArray = new SnmpOid[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                snmpOidArray[i] = new SnmpOid((long)(i + 1));
            }
            return new SnmpCachedData(l, snmpOidArray, objectArray);
        }
    }
}

