/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Objects;
import sun.security.util.Debug;
import sun.security.util.DerValue;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public final class OCSPNonceExtension
extends Extension {
    private static final String EXTENSION_NAME = "OCSPNonce";
    private byte[] nonceData = null;

    public OCSPNonceExtension(int n) throws IOException {
        this(false, n);
    }

    public OCSPNonceExtension(boolean bl, int n) throws IOException {
        this.extensionId = PKIXExtensions.OCSPNonce_Id;
        this.critical = bl;
        if (n <= 0) {
            throw new IllegalArgumentException("Length must be a positive integer");
        }
        SecureRandom secureRandom = new SecureRandom();
        this.nonceData = new byte[n];
        secureRandom.nextBytes(this.nonceData);
        this.extensionValue = new DerValue(4, this.nonceData).toByteArray();
    }

    public OCSPNonceExtension(byte[] byArray) throws IOException {
        this(false, byArray);
    }

    public OCSPNonceExtension(boolean bl, byte[] byArray) throws IOException {
        this.extensionId = PKIXExtensions.OCSPNonce_Id;
        this.critical = bl;
        Objects.requireNonNull(byArray, "Nonce data must be non-null");
        if (byArray.length <= 0) {
            throw new IllegalArgumentException("Nonce data must be at least 1 byte in length");
        }
        this.nonceData = (byte[])byArray.clone();
        this.extensionValue = new DerValue(4, this.nonceData).toByteArray();
    }

    public byte[] getNonceValue() {
        return (byte[])this.nonceData.clone();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append(EXTENSION_NAME).append(": ");
        stringBuilder.append(this.nonceData == null ? "" : Debug.toString(this.nonceData));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return EXTENSION_NAME;
    }
}

