/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

public class AnchorCertificates {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final String HASH = "SHA-256";
    private static Set<String> certs = Collections.emptySet();
    private static Set<X500Principal> certIssuers = Collections.emptySet();

    public static boolean contains(X509Certificate x509Certificate) {
        String string = X509CertImpl.getFingerprint((String)HASH, (X509Certificate)x509Certificate);
        boolean bl = certs.contains(string);
        if (bl && debug != null) {
            debug.println("AnchorCertificate.contains: matched " + x509Certificate.getSubjectDN());
        }
        return bl;
    }

    public static boolean issuerOf(X509Certificate x509Certificate) {
        return certIssuers.contains(x509Certificate.getIssuerX500Principal());
    }

    private AnchorCertificates() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                block15: {
                    File file = new File(System.getProperty("java.home"), "lib/security/cacerts");
                    try {
                        KeyStore keyStore = KeyStore.getInstance("JKS");
                        try (FileInputStream fileInputStream = new FileInputStream(file);){
                            keyStore.load(fileInputStream, null);
                            certs = new HashSet();
                            certIssuers = new HashSet();
                            Enumeration<String> enumeration = keyStore.aliases();
                            while (enumeration.hasMoreElements()) {
                                String string = enumeration.nextElement();
                                if (!string.contains(" [jdk")) continue;
                                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                                certs.add(X509CertImpl.getFingerprint((String)AnchorCertificates.HASH, (X509Certificate)x509Certificate));
                                certIssuers.add(x509Certificate.getSubjectX500Principal());
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (debug == null) break block15;
                        debug.println("Error parsing cacerts");
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        });
    }
}

