/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing;

import com.sun.tracing.Probe;
import java.lang.reflect.Field;

public abstract class ProbeSkeleton
implements Probe {
    protected Class<?>[] parameters;

    protected ProbeSkeleton(Class<?>[] classArray) {
        this.parameters = classArray;
    }

    public abstract boolean isEnabled();

    public abstract void uncheckedTrigger(Object[] var1);

    private static boolean isAssignable(Object object, Class<?> clazz) {
        if (object != null && !clazz.isInstance(object)) {
            if (clazz.isPrimitive()) {
                try {
                    Field field = object.getClass().getField("TYPE");
                    return clazz.isAssignableFrom((Class)field.get(null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    public void trigger(Object ... objectArray) {
        if (objectArray.length != this.parameters.length) {
            throw new IllegalArgumentException("Wrong number of arguments");
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (ProbeSkeleton.isAssignable(objectArray[i], this.parameters[i])) continue;
            throw new IllegalArgumentException("Wrong type of argument at position " + i);
        }
        this.uncheckedTrigger(objectArray);
    }
}

