/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing.dtrace;

import com.sun.tracing.Provider;
import com.sun.tracing.ProviderFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.tracing.dtrace.Activation;
import sun.tracing.dtrace.DTraceProvider;
import sun.tracing.dtrace.JVM;

public final class DTraceProviderFactory
extends ProviderFactory {
    public <T extends Provider> T createProvider(Class<T> clazz) {
        DTraceProvider dTraceProvider = new DTraceProvider(clazz);
        Object t = dTraceProvider.newProxyInstance();
        dTraceProvider.setProxy(t);
        dTraceProvider.init();
        new Activation(dTraceProvider.getModuleName(), new DTraceProvider[]{dTraceProvider});
        return t;
    }

    public Map<Class<? extends Provider>, Provider> createProviders(Set<Class<? extends Provider>> set, String string) {
        HashMap<Class<? extends Provider>, Provider> hashMap = new HashMap<Class<? extends Provider>, Provider>();
        HashSet<DTraceProvider> hashSet = new HashSet<DTraceProvider>();
        for (Class<? extends Provider> clazz : set) {
            DTraceProvider dTraceProvider = new DTraceProvider(clazz);
            hashSet.add(dTraceProvider);
            hashMap.put(clazz, (Provider)dTraceProvider.newProxyInstance());
        }
        new Activation(string, hashSet.toArray(new DTraceProvider[0]));
        return hashMap;
    }

    public static boolean isSupported() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                RuntimePermission runtimePermission = new RuntimePermission("com.sun.tracing.dtrace.createProvider");
                securityManager.checkPermission(runtimePermission);
            }
            return JVM.isSupported();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

